//
//  TextRasterprint.m
//  POSSDKForIOS 2013-07-31(2)
//
//  Created by liangchenying on 12-4-29.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "TextRasterprint.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface TextRasterprint()
@property (nonatomic, retain) POSSDK	 *pos_sdk;
@end

@implementation TextRasterprint

@synthesize TextRasterPrintConent;
@synthesize Back;
@synthesize FontNameButton;
@synthesize FontStyleButton;
@synthesize TextRasterPrintFontSize;
@synthesize LineBreakModeButton;
@synthesize TextRasterPrintPrinterWidth;
@synthesize TextRasterPrint;
@synthesize Cut;

@synthesize pos_sdk	              = _pos_sdk;

@synthesize array_FontName		  = _array_FontName;
@synthesize array_FontStyle       = _array_FontStyle;
@synthesize array_LineBreakMode	  = _array_LineBreakMode;

@synthesize selectedFontName	  = _selectedFontName;
@synthesize selectedFontStyle     = _selectedFontStyle;
@synthesize selectedLineBreakMode = _selectedLineBreakMode;


- (NSMutableArray*)array_FontName
{
    if(_array_FontName  == nil)
    {
        _array_FontName = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_FontName;
}

- (NSMutableArray*)array_FontStyle
{
    if(_array_FontStyle  == nil)
    {
        _array_FontStyle = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_FontStyle;
}

- (NSMutableArray*)array_LineBreakMode
{
    if(_array_LineBreakMode  == nil)
    {
        _array_LineBreakMode = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_LineBreakMode;
}

- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) 
    {
        //**************************************************************************************************
        //Add object for array_FontName
        NSArray  *FontList = [UIFont familyNames];
        [self.array_FontName addObjectsFromArray:FontList];
        
        //**************************************************************************************************
        //Add object for array_FontStyle for every Font
        [self.array_FontStyle addObjectsFromArray:[UIFont fontNamesForFamilyName:[self.array_FontName objectAtIndex:0]]];
        
        //**************************************************************************************************
        //Add object for array_LineBreakMode
        [self.array_LineBreakMode addObject:@"Word Wrap"];
        [self.array_LineBreakMode addObject:@"Character Wrap"];
        [self.array_LineBreakMode addObject:@"Clip"];
        [self.array_LineBreakMode addObject:@"Head Truncation"];
        [self.array_LineBreakMode addObject:@"Tail Truncation"];
        [self.array_LineBreakMode addObject:@"Middle Truncation"];
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    self.selectedFontName       = 0;
    self.selectedFontStyle      = 0;
    self.selectedLineBreakMode  = 0;
    
    [self.TextRasterPrintConent       setDelegate:self];
    [self.TextRasterPrintFontSize     setDelegate:self];
    
    [self.FontNameButton              setTitle:[self.array_FontName objectAtIndex:0] forState:UIControlStateNormal];
    [self.FontStyleButton             setTitle:[self.array_FontStyle objectAtIndex:0] forState:UIControlStateNormal];
    [self.LineBreakModeButton         setTitle:@"Word Wrap" forState:UIControlStateNormal];       
    [self.TextRasterPrintFontSize     setText:@"34"];
    [self.TextRasterPrintPrinterWidth setDelegate:self];    
    [self.TextRasterPrintPrinterWidth setText:@"500"];
    [self.TextRasterPrintConent       setText:@"We strive to be the expert supplier of printers.Our POS series printers can print text,image and barcode.It's a wise choice for you to choose our printers."];
}

//*************************************************************************************************
//Exit the keyboard by clicking "return" for UITextField
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
        [self.TextRasterPrintFontSize     resignFirstResponder];
        [self.TextRasterPrintPrinterWidth resignFirstResponder];
        return NO;
    } 
    return YES;
}

//*************************************************************************************************
//Exit the keyboard by clicking "return" for UITextView
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
    if ([text isEqualToString:@"\n"])
    {
        [self.TextRasterPrintConent  resignFirstResponder];
        return NO;
    }
    return YES;
}

//*************************************************************************************************
//Cut Paper
- (IBAction)Cut:(id)sender
{
    SInt32 error_code = SUCCESS;
    
    error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:50];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
    
ExitLine:
    return;
}

//**************************************************************************************************
//Get Font Name Index
- (IBAction)selectFontName:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedFontName = selectedIndex;    
        [self.FontNameButton setTitle:selectedValue forState:UIControlStateNormal];
        
        [self.array_FontStyle removeAllObjects];
        
        NSArray *FontStyleList = [UIFont fontNamesForFamilyName:[self.array_FontName objectAtIndex:self.selectedFontName]];
        //if FontStyleList is empty
        if (FontStyleList.count == 0) {
            [self.array_FontStyle addObject:@""];
        }else{
            [self.array_FontStyle addObjectsFromArray:FontStyleList];
        }
        if([self.array_FontStyle count] < 1)
        {
            //
        }
        self.selectedFontStyle = 0;
        [self.FontStyleButton setTitle:[self.array_FontStyle objectAtIndex:self.selectedFontStyle] forState:UIControlStateNormal];
        
        
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Font Name" Sheet:self.array_FontName Selected:self.selectedFontName DoneButton:done CancelButton:cancel Action:sender];
 }

//**************************************************************************************************
//Get Font Style Index
- (IBAction)selectFontStyle:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedFontStyle = selectedIndex;    
        [self.FontStyleButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Font Style" Sheet:self.array_FontStyle Selected:self.selectedFontStyle DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Get Line Break Mode Index
- (IBAction)selectLineBreakMode:(id)sender
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedLineBreakMode = selectedIndex;    
        [self.LineBreakModeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Line Break Mode" Sheet:self.array_LineBreakMode Selected:self.selectedLineBreakMode DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Text raster Print
- (IBAction)textRasterPrint:(id)sender 
{
    SInt32   error_code = SUCCESS;
    SInt32   font_size  = 0;
    SInt32   width      = 0;
    SInt32   i          = 0;
	SInt32   line_break = 0;
    
    //**************************************************************************************************
    //If Text Conent == nil ,text cannot be printed.
    JudgeParamNil(TextRasterPrintConent,@"Text == nil,Please input text content");
    
    //**************************************************************************************************
    //If FontSize == nil ,text cannot be printed.
    JudgeParamNil(TextRasterPrintFontSize,@"FontSize == nil,Please input Font Size");
    JudgeParamDigitOrNot(TextRasterPrintFontSize, @"ERROR Font Size! It must be  digit."); 
    
     //**********************************************************************************************
	//Printer width cannot be nil,
    JudgeParamNil(TextRasterPrintPrinterWidth, @"PrinterWidth == nil,Please input Printer Width");
    
    //**********************************************************************************************
	//Judge printer width must be digits
    JudgeParamDigitOrNot(TextRasterPrintPrinterWidth, @"ERROR Printer width! It must be   0  or 64-2040.");
    
    //**********************************************************************************************
	//Printer width must be 0 or 64-2040
    width      = [self.TextRasterPrintPrinterWidth.text intValue];    
    JudgePrinterWidthRange(width,@"ERROR Printer width! It must be  0  or 64-2040.",2040);
    
    //**************************************************************************************************
    //    //Get font size
    font_size  = [self.TextRasterPrintFontSize.text intValue];
    if (width >= 64 && width <= 2040) 
    {
        JudgeParamRange(font_size, 1, width, @"ERROR Font Size! Font Size must be less than Printer Width");
    }
    
	//**************************************************************************************************
    //Use print raster Print
	if ([[self.LineBreakModeButton currentTitle] isEqualToString: @"Word Wrap"]) 
    {
        line_break = UILineBreakModeWordWrap;
    }
    else if ([[self.LineBreakModeButton currentTitle] isEqualToString:@"Character Wrap"]) 
    {
        line_break = UILineBreakModeCharacterWrap;
    }
	else if ([[self.LineBreakModeButton currentTitle] isEqualToString: @"Clip"]) 
    {
        line_break = UILineBreakModeClip;
    }
	else if ([[self.LineBreakModeButton currentTitle] isEqualToString: @"Head Truncation"]) 
    {
        line_break = UILineBreakModeHeadTruncation;
    }
	else if ([[self.LineBreakModeButton currentTitle] isEqualToString: @"Tail Truncation"]) 
    {
        line_break = UILineBreakModeTailTruncation;
    }
	else if ([[self.LineBreakModeButton currentTitle] isEqualToString: @"Middle Truncation"]) 
    {
        line_break = UILineBreakModeMiddleTruncation;
    }

    //**************************************************************************************************
    //Use print raster Print 
    error_code = [self.pos_sdk textStandardModeRasterPrint:self.TextRasterPrintConent.text FontName:[self.FontStyleButton currentTitle] FontSize:font_size LineBreakMode:line_break PrinterWidth:width];
    
    if (error_code != SUCCESS) 
    {
       AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
  
ExitLine:
    return;   
}

//**************************************************************************************************
//Back to MainView
- (IBAction)Back:(id)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)viewDidUnload
{
    [self setFontNameButton:nil];
    [self setFontStyleButton:nil];
    [self setTextRasterPrintFontSize:nil];
    [self setLineBreakModeButton:nil];
    [self setTextRasterPrintPrinterWidth:nil];
    [self setTextRasterPrint:nil];
    [self setTextRasterPrintConent:nil];
    [self setCut:nil];
    [self setBack:nil];
	
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

- (void)dealloc 
{
    [self.FontNameButton release];
    [self.FontStyleButton release];
    [self.TextRasterPrintFontSize release];
    [self.LineBreakModeButton release];
    [self.TextRasterPrintPrinterWidth release];
    [self.TextRasterPrint release];
    [self.TextRasterPrintConent release];
    [self.Cut release];
    [self.array_FontName release];
    [self.array_FontStyle release];
    [self.array_LineBreakMode release];
    [self.Back release];	
    [super dealloc];
}

@end
